function [DeconvImg,DecAdd,ReadStd,DecSub] = DeconvEELS(hObject,handles)

global tracer

if isempty(tracer)
    tracer=1;
else
    DeconvImg = [];
    DecAdd    = [];
    ReadStd   = [];
    DecSub    = [];
    clearvars -except DeconvImg DecAdd ReadStd DecSub
    return
end

%% Load File
image       = load(fullfile(tempdir,'ShowOrg.mat')).image;
Fit         = load(fullfile(tempdir,'SubtrZLP.mat')).Data;
Add         = load(fullfile(tempdir,'Add.mat')).Add;
SubtrZLPLog = load(fullfile(tempdir,'SubtrZLPLog.mat')).SubtrZLPLog ;

%% Get Handles
Fine      =            get(handles.AlignPanel,'UserData');
Energies  =            get(handles.ZLPAlign,'UserData');
GPU       =            get(handles.GPU,'Value');
Factor1   = str2double(get(handles.DecFac1,'String'));
Factor2   = str2double(get(handles.DecFac2,'String'));
DecIter   = str2double(get(handles.DecIter,'String'));
DenInt    =            get(handles.ShowInt,'UserData');
Logbook   =            get(handles.Logbook,'UserData');
SpecBin   = str2double(get(handles.SpecBinning,'String'));

SubtrZLP  = Fit{1};
cutoff    = Fit{2};
ZLPVAR    = Fit{5};
clearvars Fit

%% Add Padding
OrgLength    = size(image,3);
image        = cat(3,image,Add);

%% Get Noise parameters
Gain         = str2double(get(handles.GainVal,'String'));
Corr         = get(handles.PSF,'UserData');

if ~Fine(1,1)==2
    PSF      = Corr{1,1};
    PSFInter = zeros(size(PSF));
    PSFInter(1,(size(PSF,2)+1)/2)= 1;
    Deriv    = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
    Deriv    = mean(Deriv,1);  
    Deriv    = (1/4).^2.*(Deriv - circshift(Deriv,-1,2)).^2;
    Deriv    = reshape(Deriv,[1,1,size(Deriv,3)]);
    Deriv    = repmat(Deriv,[size(image,1),size(image,2),1]);
else
   PSF       = Corr{1,2};
   PSFInter  = Corr{1,5};
   Deriv     = 0;
end

ReadStd      = str2double(get(handles.ReadStd,'String'));
ReadFull     = str2double(get(handles.ReadFull,'String'));

ReadVAR      = ReadStd.^2;
FullVAR      = ReadFull.^2.*size(image,3).*SpecBin./2048; 
Phi          = str2double(get(handles.PhiVal,'String'));

A            = round(sqrt(size(image,1)*size(image,2)));

%% Substract ZLP and determine noise
% for the success of deconvolution it is important to get rid of the ZLP!
% else, it cripples the results with "wave artefacts" in the energy spectra,
% that look quite similar to plasmon peaks, but are on different energy positions.
% It can be shown by deconvolving simulated spectra that subtracting the ZLP
% first before deconvolution leads to the correct positions and the "true" spectra.
image(image+ReadStd<0)       = randn.*ReadStd;

if ~isempty(cutoff)
   SubtrZLP(:,:,cutoff(1):cutoff(2))=image(:,:,cutoff(1):cutoff(2));       % sets the region of the ZLP to 0 if selected to get rid of the excess in pre-ZLP region
   Img    = image;
   Img(   :,:,cutoff(1):cutoff(2))= 0;
   ZLPVAR(:,:,cutoff(1):cutoff(2))= 0;
   if length(Deriv)>1
      Deriv(:,:,cutoff(1):cutoff(2))=0;
   end
else
   Img    = image;
end
SubtrZLP(image+ReadStd-SubtrZLP<0)=image(image+ReadStd-SubtrZLP<0);

%% Create Kernel
[Kernel,KernelLog,DecSub] = CreateKernel(hObject,handles,image,Add);
if isempty(Kernel)
    DeconvImg = [];
    DecAdd    = [];
    ReadStd   = [];
    DecSub    = [];
    clearvars -except DeconvImg DecAdd  ReadStd DecSub
    clear global
    return
end

%% Calculate
Sum         = sum(image(:,:,1:OrgLength),3);
Mean        = mean(Sum,'all');
Norm        = Sum./Mean;
IntDev      = 0.008;%std(Sum,0,'all')./Mean;
  
%% Calculate attenuation factors
kern      = reshape(Kernel(1,1,:),[1,size(Kernel,3)]);
SizeDiff  = (size(PSF,2) - size(kern,2)+1)/2;
PSF       = PSF(1,ceil(SizeDiff):end-floor(SizeDiff));
PSF       = ifftshift(PSF)./sum(PSF,'all');
PSFInter  = PSFInter(1,ceil(SizeDiff):end-floor(SizeDiff));
PSFInter  = ifftshift(PSFInter)./sum(PSFInter,'all');
kern      = ifftshift(kern);
omega_s   = ifft(fft(kern,[],2)./fft(ifftshift(PSF,2),[],2),[],2);
omega_s   = fftshift(omega_s)./max(omega_s,[],2);
omega_s   = sum(omega_s);

omega_d   = ifft(fft(kern,[],2)./fft(ifftshift(PSFInter,2),[],2),[],2);
omega_d   = fftshift(omega_d)./max(omega_d,[],2);
omega_d   = sum(omega_d);

[~,Ind1]  = min(abs(Energies-0.75),[],2);
[~,Ind2]  = min(abs(Energies-3),[],2);
SNREst    = mean(image(:,:,Ind1:Ind2)-SubtrZLP(:,:,Ind1:Ind2),'all')/sqrt(mean((1 + IntDev.^2) .* Gain.*0.24.*image(:,:,Ind1:Ind2) + IntDev.^2.*image(:,:,Ind1:Ind2).^2 + (1+1/A).* ReadVAR,'all'))

%% Noise Estimate in Energy Direction and Lambda_Z paramters

SignalNoise = omega_s.*Gain.*Img          ./Sum.^2;
DetecNoise  = omega_d.*(1 + 1./A).*ReadVAR./Sum.^2;
ZLPNoise    = omega_s.*ZLPVAR             ./Sum.^2;


NoiseEst_Z  = Mean.*sqrt(mean(SignalNoise + DetecNoise + ZLPNoise,'all'))

lambda_1z   = Factor1./(2.*NoiseEst_Z);
lambda_2z   = Factor2./(2.*NoiseEst_Z);

%% Noise Estimate in Lateral Direction and Lambda_XY paramters
img          = Img;
img(:,:,OrgLength+1:end)=0;          
mu_R         = (Sum - img)./Sum;
Read_R       = FullVAR - ones(size(img)).*ReadVAR;
Read_R(:,:,OrgLength+1:end)=0;  
clearvars img
k2           = (1 + IntDev.^2./4) .* Gain .* mu_R.*Mean + (1 + IntDev.^2).*Read_R;
k2           = k2./Mean.^2;

SignalNoise  = omega_s.*(1 + IntDev.^2./4)           .* Gain.*mu_R.^2 .* Img./Sum./Mean ;
NormNoise    =                                                     k2 .*(Img./Sum).^2;
DetecNoise   = omega_d.*(1 + IntDev.^2) .*(1 + Phi./A).*mu_R.^2 .*ReadVAR./Mean.^2 ;
ZLPNoise     = omega_s.*     IntDev.^2 .*ZLPVAR./Sum./Mean;
Deriv        = Deriv./Mean.^2;
NoiseEst_XY  = Mean.*sqrt(mean(SignalNoise + NormNoise + DetecNoise + ZLPNoise + Deriv,'all'))

lambda_1xy   = Factor1./(2.*NoiseEst_XY);
lambda_2xy   = Factor2./(2.*NoiseEst_XY);
clearvars NoiseEst_XY

%% Parameter for Deconvolution Algorithm
ReadVAR     = (1+1./A).*ReadStd.^2;

%% ADMM Deconvolution

tic;
try
    switch GPU

        case 1
           [DeconvImg,DecIter] = gpu_DecEELS3D(image,Kernel,SubtrZLP,Norm,Gain,ReadVAR,lambda_1z,lambda_1xy,lambda_2z,lambda_2xy,OrgLength,DecIter);
           %DeconvImg = gpu_RLA(image-SubtrZLP,Kernel,DecIter,Norm);
        otherwise
            [DeconvImg,DecIter] =     DecEELS3D(image,Kernel,SubtrZLP,Norm,Gain,ReadVAR,lambda_1z,lambda_1xy,lambda_2z,lambda_2xy,OrgLength,DecIter);
    end
catch
    switch GPU
        case 1
            msgbox('Not enough RAM on GPU!')
        otherwise
            msgbox('Not enough RAM!')
    end
    DeconvImg=[];
end
toc;
if isempty(DeconvImg)
    DecAdd  = [];
    ReadStd = [];
    DecSub  = [];
    clearvars -except DeconvImg DecAdd ReadStd DecSub
    clear global
    return
end

DenInt    = repmat(DenInt,[1,1,size(DeconvImg,3)]);
DeconvImg = DeconvImg./Mean;
DeconvImg = DeconvImg.*DenInt;
DecAdd    = DeconvImg(:,:,OrgLength+1:end);                                % separate padding from original data
DeconvImg = DeconvImg(:,:,1:OrgLength);

%% Create Logbook
Logbook{1}= strrep(Logbook{1},'Org','Deconvolved');

Logbook{end+1} = [];
Logbook{end+1} = '-----------------------------------------------------------------------------';
Logbook{end+1} = [];
Logbook{end+1} = ['Deconvolution: NoiseModel: MPG | Iter: ' , num2str(DecIter) , '  |  Detector Noise: ' , num2str(sqrt(mean(ReadVAR,'all'))) ,'  |  UserFactor1: ' ,num2str(Factor1),'  |  UserFactor2: ' ,num2str(Factor2),'  |  Smoothed GainVal: ' ,num2str(Gain)];

Logbook{end+1}  = [];
Logbook{end+1}  = '  Used Subtraction:';
for i=1:size(SubtrZLPLog,1)
    SubtrZLPLog{i,:} = ['    ',SubtrZLPLog{i,:}];
end
Logbook         = [Logbook;SubtrZLPLog];
Logbook{end+1}  = [];
Logbook{end+1}  = '  Used Kernel:';
for i=1:size(KernelLog,1)
    KernelLog{i,:} = ['    ',KernelLog{i,:}];
end
Logbook         = [Logbook;KernelLog];
Logbook{end+1}  = [];

if ~isempty(cutoff)
    Logbook{end+1} = ['Counts between ',num2str(Energies(cutoff(1))),'eV and ',num2str(Energies(cutoff(2))),'eV were set to 0, due to ZLP residuals.'];
end

DeconvLog = Logbook;
save(fullfile(tempdir,'DeconvLog.mat'),'DeconvLog');

clearvars -except DeconvImg DecAdd ReadStd DecSub
end